"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
0 && (module.exports = {
    createLayoutSegmentPromises: null,
    createNestedLayoutNavigationPromises: null,
    createRootNavigationPromises: null
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createLayoutSegmentPromises: function() {
        return createLayoutSegmentPromises;
    },
    createNestedLayoutNavigationPromises: function() {
        return createNestedLayoutNavigationPromises;
    },
    createRootNavigationPromises: function() {
        return createRootNavigationPromises;
    }
});
const _hooksclientcontextsharedruntime = require("../../shared/lib/hooks-client-context.shared-runtime");
const _segment = require("../../shared/lib/segment");
const _readonlyurlsearchparams = require("./readonly-url-search-params");
const layoutSegmentPromisesCache = new WeakMap();
function createLayoutSegmentPromises(tree) {
    if (process.env.NODE_ENV === 'production') {
        return null;
    }
    // Check if we already have cached promises for this tree
    const cached = layoutSegmentPromisesCache.get(tree);
    if (cached) {
        return cached;
    }
    // Create new promises and cache them
    const segmentPromises = new Map();
    const segmentsPromises = new Map();
    const parallelRoutes = tree[1];
    for (const parallelRouteKey of Object.keys(parallelRoutes)){
        const segments = (0, _segment.getSelectedLayoutSegmentPath)(tree, parallelRouteKey);
        // Use the shared logic to compute the segment value
        const segment = (0, _segment.computeSelectedLayoutSegment)(segments, parallelRouteKey);
        segmentPromises.set(parallelRouteKey, (0, _hooksclientcontextsharedruntime.createDevToolsInstrumentedPromise)('useSelectedLayoutSegment', segment));
        segmentsPromises.set(parallelRouteKey, (0, _hooksclientcontextsharedruntime.createDevToolsInstrumentedPromise)('useSelectedLayoutSegments', segments));
    }
    const result = {
        selectedLayoutSegmentPromises: segmentPromises,
        selectedLayoutSegmentsPromises: segmentsPromises
    };
    // Cache the result for future renders
    layoutSegmentPromisesCache.set(tree, result);
    return result;
}
const rootNavigationPromisesCache = new WeakMap();
function createRootNavigationPromises(tree, pathname, searchParams, pathParams) {
    if (process.env.NODE_ENV === 'production') {
        return null;
    }
    // Create stable cache keys from the values
    const searchParamsString = searchParams.toString();
    const pathParamsString = JSON.stringify(pathParams);
    const cacheKey = `${pathname}:${searchParamsString}:${pathParamsString}`;
    // Get or create the cache for this tree
    let treeCache = rootNavigationPromisesCache.get(tree);
    if (!treeCache) {
        treeCache = new Map();
        rootNavigationPromisesCache.set(tree, treeCache);
    }
    // Check if we have cached promises for this combination
    const cached = treeCache.get(cacheKey);
    if (cached) {
        return cached;
    }
    const readonlySearchParams = new _readonlyurlsearchparams.ReadonlyURLSearchParams(searchParams);
    const layoutSegmentPromises = createLayoutSegmentPromises(tree);
    const promises = {
        pathname: (0, _hooksclientcontextsharedruntime.createDevToolsInstrumentedPromise)('usePathname', pathname),
        searchParams: (0, _hooksclientcontextsharedruntime.createDevToolsInstrumentedPromise)('useSearchParams', readonlySearchParams),
        params: (0, _hooksclientcontextsharedruntime.createDevToolsInstrumentedPromise)('useParams', pathParams),
        ...layoutSegmentPromises
    };
    treeCache.set(cacheKey, promises);
    return promises;
}
const nestedLayoutPromisesCache = new WeakMap();
function createNestedLayoutNavigationPromises(tree, parentNavPromises) {
    if (process.env.NODE_ENV === 'production') {
        return null;
    }
    const parallelRoutes = tree[1];
    const parallelRouteKeys = Object.keys(parallelRoutes);
    // Only create promises if there are parallel routes at this level
    if (parallelRouteKeys.length === 0) {
        return null;
    }
    // Get or create the cache for this tree
    let treeCache = nestedLayoutPromisesCache.get(tree);
    if (!treeCache) {
        treeCache = new Map();
        nestedLayoutPromisesCache.set(tree, treeCache);
    }
    // Check if we have cached promises for this parent combination
    const cached = treeCache.get(parentNavPromises);
    if (cached) {
        return cached;
    }
    // Create merged promises
    const layoutSegmentPromises = createLayoutSegmentPromises(tree);
    const promises = {
        ...parentNavPromises,
        ...layoutSegmentPromises
    };
    treeCache.set(parentNavPromises, promises);
    return promises;
}

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=navigation-devtools.js.map